<?php
/*
Plugin Name: Smart Slider 3 Pro
Plugin URI: https://smartslider3.com/
Update URI: false
Description: The perfect all-in-one responsive slider solution for WordPress.
Version: 3.5.1.31
Requires PHP: 7.0
Requires at least: 5.0
Author: Nextend
Author URI: https://smartslider3.com
License: GPLv3 or later
License URI: http://www.gnu.org/licenses/gpl-3.0.html
 */

if (!defined('SMARTSLIDER3_LIBRARY_PATH')) {
    define('SMARTSLIDER3_LIBRARY_PATH', dirname(__FILE__) . DIRECTORY_SEPARATOR . 'Nextend');
}

add_filter('pre_http_request', function($pre, $r, $url) {
    if (strpos($url, 'api.nextendweb.com/v1/') === false) {
        return $pre;
    }
    
    $body = $r['body'];
    $body_data = is_array($body) ? $body : json_decode($body, true);
    
    if (!is_array($body_data) || !isset($body_data['action']) || $body_data['action'] !== 'asset' || !isset($body_data['asset'])) {
        return $pre;
    }
    
    $asset_url = $body_data['asset'];
    if (preg_match('#smartslider3\.com/([0-9]+)#', $asset_url, $matches)) {
        $alternative_url = "https://dl.gpltimes.com/file/gpltimes/smartslider3/asset_{$matches[1]}.zip";
        $response = wp_remote_get($alternative_url);
        
        if (!is_wp_error($response) && wp_remote_retrieve_response_code($response) === 200) {
            return $response;
        }
    }
    
    return $pre;
}, 10, 3);

if (!version_compare(PHP_VERSION, '7.0', '>=')) {

    require_once SMARTSLIDER3_LIBRARY_PATH . '/WordPress/Fail.php';
    add_action('admin_notices', 'smartslider3_fail_php_version');

} else if (!version_compare(get_bloginfo('version'), '5.0', '>=')) {

    require_once SMARTSLIDER3_LIBRARY_PATH . '/WordPress/Fail.php';
    add_action('admin_notices', 'smartslider3_fail_wp_version');

} else if (!defined('NONCE_SALT')) {

    require_once SMARTSLIDER3_LIBRARY_PATH . '/WordPress/Fail.php';
    add_action('admin_notices', 'smartslider3_fail_nonce_salt');

} else if (!function_exists('smart_slider_3_pro_plugins_loaded')) {
    define('NEXTEND_SMARTSLIDER_3_PRO_BASENAME', plugin_basename(__FILE__));
    define('NEXTEND_SMARTSLIDER_3_PRO_SLUG', 'nextend-smart-slider3-pro');

    require_once dirname(__FILE__) . '/plugin.php';
}